/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.BlockPair;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.area_condition.AreaCondition;
import com.ordana.immersive_weathering.data.block_growths.growths.IBlockGrowth;
import com.ordana.immersive_weathering.data.position_tests.IPositionRuleTest;
import com.ordana.immersive_weathering.mixins.accessors.RandomBlockMatchTestAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3818;
import net.minecraft.class_3825;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public class ConfigurableBlockGrowth
implements IBlockGrowth {
    public static final ConfigurableBlockGrowth EMPTY = new ConfigurableBlockGrowth(List.of(), 1.0f, (class_3825)class_3818.field_16868, AreaCondition.EMPTY, List.of(), Optional.of(class_6885.method_40246((class_6880[])new class_6880[]{class_6880.method_40223((Object)class_2246.field_10124)})), List.of(), false, false);
    public static final Codec<ConfigurableBlockGrowth> CODEC = RecordCodecBuilder.create(instance -> {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    });
    @Nullable
    private final class_6885<class_2248> owners;
    private final List<TickSource> tickSources;
    private final float growthChance;
    private final class_3825 targetPredicate;
    private final class_6005<class_2350> growthForDirection;
    private final Map<class_2350, class_6005<BlockPair>> blockGrowths;
    private final Set<class_2248> possibleBlocks;
    private final List<IPositionRuleTest> positionTests;
    private final boolean targetSelf;
    private final boolean destroyTarget;
    private final int maxRange;
    private final AreaCondition areaCondition;

    public ConfigurableBlockGrowth(List<TickSource> sources, float growthChance, class_3825 targetPredicate, AreaCondition areaCheck, List<DirectionalList> growthForDirection, Optional<class_6885<class_2248>> owners, List<IPositionRuleTest> biomePredicates, Boolean targetSelf, Boolean destroyTarget) {
        this.tickSources = sources;
        this.growthChance = growthChance;
        this.owners = owners.orElse(null);
        this.positionTests = biomePredicates;
        this.targetPredicate = targetPredicate;
        class_6005.class_6006 dirBuilder = class_6005.method_34971();
        ImmutableMap.Builder growthBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder blockBuilder = new ImmutableSet.Builder();
        for (DirectionalList randomBlockList : growthForDirection) {
            if (randomBlockList.direction.isEmpty()) {
                dirBuilder = class_6005.method_34971();
                growthBuilder = new ImmutableMap.Builder();
                blockBuilder = new ImmutableSet.Builder();
                this.decodeRandomList(class_2350.field_11036, (class_6005.class_6006<class_2350>)dirBuilder, (ImmutableMap.Builder<class_2350, class_6005<BlockPair>>)growthBuilder, (ImmutableSet.Builder<class_2248>)blockBuilder, randomBlockList);
                for (class_2350 d : class_2350.values()) {
                    if (d == class_2350.field_11036) continue;
                    growthBuilder.put((Object)d, randomBlockList.randomList);
                    dirBuilder.method_34975((Object)d, 1);
                }
                break;
            }
            this.decodeRandomList(randomBlockList.direction.get(), (class_6005.class_6006<class_2350>)dirBuilder, (ImmutableMap.Builder<class_2350, class_6005<BlockPair>>)growthBuilder, (ImmutableSet.Builder<class_2248>)blockBuilder, randomBlockList);
        }
        this.growthForDirection = dirBuilder.method_34974();
        this.blockGrowths = growthBuilder.build();
        this.possibleBlocks = blockBuilder.build();
        this.areaCondition = areaCheck;
        this.maxRange = this.areaCondition.getMaxRange();
        this.targetSelf = targetSelf;
        this.destroyTarget = destroyTarget;
    }

    private void decodeRandomList(class_2350 direction, class_6005.class_6006<class_2350> dirBuilder, ImmutableMap.Builder<class_2350, class_6005<BlockPair>> growthBuilder, ImmutableSet.Builder<class_2248> blockBuilder, DirectionalList v) {
        int weight = v.weight.orElse(1);
        dirBuilder.method_34975((Object)direction, weight);
        growthBuilder.put((Object)direction, v.randomList);
        v.randomList.method_34994().stream().map(class_6008.class_6010::method_34983).forEach(o -> {
            class_2680 s;
            class_2680 f = (class_2680)o.getFirst();
            if (f != null) {
                blockBuilder.add((Object)f.method_26204());
            }
            if ((s = (class_2680)o.getFirst()) != null) {
                blockBuilder.add((Object)s.method_26204());
            }
        });
    }

    public List<DirectionalList> encodeRandomLists() {
        ArrayList<DirectionalList> list = new ArrayList<DirectionalList>();
        for (class_6008.class_6010 e : this.growthForDirection.method_34994()) {
            Optional<Integer> weight;
            Optional<class_2350> dir;
            if (this.growthForDirection.method_34994().size() == 1) {
                dir = Optional.empty();
                weight = Optional.empty();
            } else {
                dir = Optional.of((class_2350)e.method_34983());
                weight = Optional.of(e.method_34979().method_34976());
            }
            list.add(new DirectionalList(dir, weight, this.blockGrowths.get(e.method_34983())));
        }
        return list;
    }

    public class_3825 getTargetPredicate() {
        return this.targetPredicate;
    }

    public AreaCondition getAreaCondition() {
        return this.areaCondition;
    }

    public Set<class_2248> getPossibleBlocks() {
        return this.possibleBlocks;
    }

    public boolean targetSelf() {
        return this.targetSelf;
    }

    public boolean destroyTarget() {
        return this.destroyTarget;
    }

    public List<IPositionRuleTest> getPositionTests() {
        return this.positionTests;
    }

    public List<TickSource> getTickSources() {
        return this.tickSources;
    }

    public boolean isEmpty() {
        return this.possibleBlocks.isEmpty();
    }

    private boolean canGrow(class_2338 pos, class_1937 level, Supplier<class_6880<class_1959>> biome) {
        if (this.growthChance == 0.0f) {
            return false;
        }
        if (level.field_9229.method_43057() < this.growthChance) {
            for (IPositionRuleTest positionTest : this.positionTests) {
                if (positionTest.test(biome, pos, level)) continue;
                return false;
            }
            return PlatformHelper.isAreaLoaded((class_4538)level, (class_2338)pos, (int)this.maxRange);
        }
        return false;
    }

    public float getGrowthChance() {
        return this.growthChance;
    }

    @Nullable
    public Iterable<class_2248> getOwners() {
        if (this.owners == null) {
            return null;
        }
        return this.owners.method_40239().map(class_6880::comp_349).collect(Collectors.toList());
    }

    @Override
    public void tryGrowing(class_2338 pos, class_2680 self, class_3218 level, Supplier<class_6880<class_1959>> biome) {
        if (this.canGrow(pos, (class_1937)level, biome)) {
            class_2350 dir = this.growthForDirection.method_34973(level.field_9229).orElse(class_2350.field_11036);
            class_5819 seed = class_5819.method_43049((long)class_3532.method_15389((class_2382)pos));
            class_2338 targetPos = this.targetSelf ? pos : pos.method_10093(dir);
            class_2680 target = level.method_8320(targetPos);
            if (this.targetSelf || this.targetPredicate.method_16768(target, seed)) {
                BlockPair toPlace;
                class_6005<BlockPair> l;
                class_3825 class_38252;
                if (this.targetSelf && (class_38252 = this.targetPredicate) instanceof RandomBlockMatchTestAccessor) {
                    RandomBlockMatchTestAccessor rbm = (RandomBlockMatchTestAccessor)class_38252;
                    if (seed.method_43057() >= rbm.getProbability()) {
                        return;
                    }
                }
                if ((l = this.blockGrowths.get(dir)) != null && (toPlace = (BlockPair)l.method_34973(level.field_9229).orElse(null)) != null && ((class_2680)toPlace.getFirst()).method_26184((class_4538)level, targetPos)) {
                    class_2338 targetPos2 = null;
                    class_2680 target2 = null;
                    boolean db = toPlace.isDouble();
                    if (db && !this.targetPredicate.method_16768(target2 = level.method_8320(targetPos2 = targetPos.method_10093(dir)), seed = class_5819.method_43049((long)class_3532.method_15389((class_2382)pos)))) {
                        return;
                    }
                    if (this.areaCondition.test(pos, (class_1937)level, this)) {
                        if (this.destroyTarget) {
                            level.method_22352(targetPos, true);
                        }
                        level.method_8501(targetPos, this.getStateToPlace((class_2680)toPlace.getFirst(), target, (class_1937)level, targetPos));
                        if (db) {
                            if (this.destroyTarget) {
                                level.method_22352(targetPos2, true);
                            }
                            level.method_8501(targetPos2, this.getStateToPlace((class_2680)toPlace.getSecond(), target2, (class_1937)level, pos));
                        }
                    }
                }
            }
        }
    }

    private class_2680 getStateToPlace(class_2680 toPlace, class_2680 target, class_1937 level, class_2338 pos) {
        if (toPlace.method_28498((class_2769)class_2741.field_12508) && target.method_26227().method_15767(class_3486.field_15517)) {
            return (class_2680)toPlace.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        return class_2248.method_9510((class_2680)toPlace, (class_1936)level, (class_2338)pos);
    }

    private static /* synthetic */ Optional lambda$static$0(ConfigurableBlockGrowth b) {
        return Optional.ofNullable(b.owners);
    }

    public record DirectionalList(Optional<class_2350> direction, Optional<Integer> weight, class_6005<BlockPair> randomList) {
        public static final Codec<DirectionalList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2350.field_29502.optionalFieldOf("direction").forGetter(DirectionalList::direction), (App)Codec.INT.optionalFieldOf("weight").forGetter(DirectionalList::weight), (App)class_6005.method_34972(BlockPair.CODEC).fieldOf("growth").forGetter(DirectionalList::randomList)).apply((Applicative)instance, DirectionalList::new));
    }
}

